<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

/**
 * Class Makbet_Elementor_Blog
 */
class Makbet_Elementor_Transform extends Makbet_Base_Widgets {

    public function get_name() {
        return 'makbet-transform';
    }

    public function get_title() {
        return esc_html__('Makbet Transform', 'makbet');
    }

    public function get_icon() {
        return 'eicon-page-transition';
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    public function get_script_depends() {
        return ['makbet-elementor-transform'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_box',
            [
                'label' => esc_html__('Box', 'makbet'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'box_icon',
            [
                'label'            => esc_html__('Icon', 'makbet'),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'box_title',
            [
                'label'   => esc_html__('Title', 'makbet'),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Projects Completed',
            ]
        );

        $repeater->add_control(
            'box_number',
            [
                'label'   => esc_html__('Number', 'makbet'),
                'type'    => Controls_Manager::TEXT,
                'default' => '1975+',
            ]
        );

        $repeater->add_control(
            'box_content',
            [
                'label'   => esc_html__('Content', 'makbet'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => 'Successfully delivered 1975+ projects with excellence and proven results.',
            ]
        );

        $repeater->add_control(
            'box-icon_icon_color',
            [
                'label'     => esc_html__('Color Icon', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [''],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'           => 'color',
                'types'          => ['gradient'],
                'selector'       => '',
                'fields_options' => [
                    'background' => [
                        'label'              => __('Background Color', 'makbet'),
                        'frontend_available' => true,
                    ],
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'       => esc_html__('Link to', 'makbet'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => ['active' => true],
                'placeholder' => esc_html__('https://your-link.com', 'makbet'),
            ]
        );

        $this->add_control(
            'box',
            [
                'label'        => esc_html__('Box', 'makbet'),
                'type'         => Controls_Manager::REPEATER,
                'fields'       => $repeater->get_controls(),
                'title_field'  => '{{{ box_title }}}',
                'item_actions' => [
                    'add'       => false,
                    'duplicate' => false,
                    'remove'    => false,
                ],
                'default'      => [
                    [
                        'box_title'   => esc_html__('Projects Completed', 'makbet'),
                        'box_number'  => esc_html__('1975+', 'makbet'),
                        'box_content' => esc_html__('Successfully delivered 1975+ projects with excellence and proven results.', 'makbet'),
                    ],
                    [
                        'box_title'   => esc_html__('Satisfied Customers', 'makbet'),
                        'box_number'  => esc_html__('99%', 'makbet'),
                        'box_content' => esc_html__('We ensure excellence with 99% customer satisfaction guaranteed.', 'makbet'),
                    ],
                    [
                        'box_title'   => esc_html__('Active Customers', 'makbet'),
                        'box_number'  => esc_html__('750K+', 'makbet'),
                        'box_content' => esc_html__('Trusted by 750K+ active customers for proven business success.', 'makbet'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Wrapper.
        $this->start_controls_section(
            'section_box_wrapper',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_wrapper_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_wrapper_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_wrapper_gap',
            [
                'label'       => esc_html__('Gaps', 'makbet'),
                'type'        => Controls_Manager::GAPS,
                'size_units'  => ['px', 'em', 'rem'],
                'placeholder' => [
                    'row'    => '30',
                    'column' => '30',
                ],
                'selectors'   => [
                    '{{WRAPPER}} .elementor-transform-wrapper' => 'gap: {{ROW}}{{UNIT}} {{COLUMN}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        // Icon.
        $this->start_controls_section(
            'section_box_icon',
            [
                'label' => esc_html__('Icon', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_icon_padding',
            [
                'label'       => esc_html__('Padding', 'makbet'),
                'type'        => Controls_Manager::DIMENSIONS,
                'size_units'  => ['px', 'em', '%'],
                'placeholder' => [
                    'top'    => '30',
                    'right'  => '30',
                    'bottom' => '30',
                    'left'   => '30',
                ],
                'selectors'   => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_content_icon_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_icon_size',
            [
                'label'     => esc_html__('Size', 'makbet'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .elementor-transform-wrapper' => '--size-icon: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box-icon_background_color',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Content.
        $this->start_controls_section(
            'section_box_content',
            [
                'label' => esc_html__('Content', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_content_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_content_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_content_title_heading',
            [
                'label'     => esc_html__('Title', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'box_content_title_typography',
                'selector' => '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-title',
            ]
        );

        $this->add_control(
            'box_content_title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_content_title_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_content_number_heading',
            [
                'label'     => esc_html__('Number', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'box_content_number_typography',
                'selector' => '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-number',
            ]
        );

        $this->add_control(
            'box_content_number_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-number' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_content_number_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_content_desc_heading',
            [
                'label'     => esc_html__('Description', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'box_content_desc_typography',
                'selector' => '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-content',
            ]
        );

        $this->add_control(
            'box_content_desc_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_content_desc_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-transform-wrapper .elementor-transform-item .box-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper', 'class', ['elementor-transform-wrapper']);
        // Item
        $this->add_render_attribute('item', 'class', 'elementor-transform-item');

        ?>

        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <?php foreach ($settings['box'] as $item) { ?>
                <?php
                $bg_css = '';
                $color_css = '';
                if(!empty($item['color_background'])) {
                    if ((isset($item['color_color']) || isset($item['__globals__']['color_color'])) && ($item['color_color_b'] || isset($item['__globals__']['color_color_b']))) {
                        $color_a = $this -> get_elementor_color_value(
                            $item['color_color'] ?? '',
                            $item['__globals__']['color_color'] ?? ''
                        );

                        $color_stop_a = isset($item['color_color_stop']) ? $item['color_color_stop']['size'] . $item['color_color_stop']['unit'] : '0%';
                        $color_b = $this -> get_elementor_color_value(
                            $item['color_color_b'] ?? '',
                            $item['__globals__']['color_color_b'] ?? ''
                        );

                        $color_stop_b = isset($item['color_color_b_stop']) ? $item['color_color_b_stop']['size'] . $item['color_color_b_stop']['unit'] : '100%';
                        $angle        = isset($item['color_gradient_angle']) ? $item['color_gradient_angle']['size'] . $item['color_gradient_angle']['unit'] : '180deg';
                        $type         = isset($item['color_gradient_type']) ? $item['color_gradient_type'] : 'linear';

                        $bg_css = "background-image: {$type}-gradient({$angle}, {$color_a} {$color_stop_a}, {$color_b} {$color_stop_b});";
                    }
                }

                if(!empty($item['box-icon_icon_color']) || !empty($item['__globals__']['box-icon_icon_color'])) {
                    $color_icon = $this -> get_elementor_color_value(
                        $item['box-icon_icon_color'] ?? '',
                        $item['__globals__']['box-icon_icon_color'] ?? ''
                    );
                    $color_css = "color: {$color_icon}";
                }
                ?>

                <div <?php $this->print_render_attribute_string('item'); ?> style="<?php echo esc_attr($bg_css); ?>">
                    <?php if (!empty($item['box_icon'])) { ?>
                        <div class="box-icon">
                            <span class="icon-wrapper" style="<?php echo esc_attr($color_css); ?>">
                                <?php \Elementor\Icons_Manager::render_icon($item['box_icon'], ['aria-hidden' => 'true']); ?>
                            </span>
                        </div>
                    <?php } ?>

                    <div class="box-content-wrapper">
                        <?php if (!empty($item['box_number'])) { ?>
                            <span class="box-number"><?php echo esc_html($item['box_number']); ?></span>
                        <?php } ?>

                        <?php if (!empty($item['box_title'])) { ?>
                            <span class="box-title"><?php echo esc_html($item['box_title']); ?></span>
                        <?php } ?>

                        <?php if (!empty($item['box_content'])) { ?>
                            <span class="box-content"><?php echo esc_html($item['box_content']); ?></span>
                        <?php } ?>
                    </div>

                </div>
            <?php } ?>
        </div>
        <?php
        wp_reset_postdata();
    }

    function get_elementor_color_value($color_value, $global_value) {
        if (!empty($global_value) && strpos($global_value, 'globals/colors?id=') === 0) {
            $global_id = str_replace('globals/colors?id=', '', $global_value);
            return "var(--e-global-color-{$global_id})";
        }

        if (!empty($color_value)) {
            return $color_value;
        }

        return '';
    }

}

$widgets_manager->register(new Makbet_Elementor_Transform());