<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

/**
 * Class Makbet_Elementor_Blog
 */
class Makbet_Elementor_Step extends Makbet_Base_Widgets {

    public function get_name() {
        return 'makbet-step';
    }

    public function get_title() {
        return esc_html__('Makbet Step', 'makbet');
    }

    public function get_icon() {
        return 'eicon-bullet-list';
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    public function get_script_depends() {
        return ['makbet-elementor-step'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_step',
            [
                'label' => esc_html__('Step', 'makbet'),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'step_title',
            [
                'label'   => esc_html__('Title', 'makbet'),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Discovery & Strategy',
            ]
        );

        $repeater->add_control(
            'step_number',
            [
                'label'   => esc_html__('Number', 'makbet'),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Step 01',
            ]
        );

        $repeater->add_control(
            'step_content',
            [
                'label'   => esc_html__('Content', 'makbet'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => 'We begin by understanding your brand, goals, and target audience. Through research and competitor analysis, we craft a tailored digital marketing strategy aligned with your business objectives.',
            ]
        );

        $repeater->add_control(
            'step_rotate',
            [
                'label'   => esc_html__('Rotate', 'makbet'),
                'type'    => Controls_Manager::NUMBER,
                'default' => '0',
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'       => esc_html__('Link to', 'makbet'),
                'type'        => Controls_Manager::URL,
                'dynamic'     => ['active' => true],
                'placeholder' => esc_html__('https://your-link.com', 'makbet'),
            ]
        );

        $this->add_control(
            'step',
            [
                'label'       => esc_html__('Step', 'makbet'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ step_title }}}',
                'default'     => [
                    [
                        'step_title'   => esc_html__('Discovery & Strategy', 'makbet'),
                        'step_number'  => esc_html__('Step 01', 'makbet'),
                        'step_content' => esc_html__('We begin by understanding your brand, goals, and target audience. Through research and competitor analysis, we craft a tailored digital marketing strategy aligned with your business objectives.', 'makbet'),
                    ],
                    [
                        'step_title'   => esc_html__('Execution & Optimization', 'makbet'),
                        'step_number'  => esc_html__('Step 02', 'makbet'),
                        'step_content' => esc_html__('Our team implements the strategy across relevant channels SEO, ads, content, and social media. We continuously monitor performance and make real-time adjustments to maximize impact.', 'makbet'),
                    ],
                    [
                        'step_title'   => esc_html__('Reporting & Growth', 'makbet'),
                        'step_number'  => esc_html__('Step 03', 'makbet'),
                        'step_content' => esc_html__('We provide transparent, data-driven reports to measure results and identify new growth opportunities. Insights from analytics guide the next phase of scaling your digital presence.', 'makbet'),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Wrapper.
        $this->start_controls_section(
            'section_step_wrapper',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'step_background_color',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-step-wrapper' => '--color-item: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'step_wrapper_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'step_wrapper_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'step_wrapper_spacing',
            [
                'label'     => esc_html__('Spacing', 'makbet'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item:not(:first-child)' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'step_wrapper_box_shadow',
                'selector' => '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item',
            ]
        );

        $this->end_controls_section();

        // Content.
        $this->start_controls_section(
            'section_step_content',
            [
                'label' => esc_html__('Content', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'step_content_spacing',
            [
                'label'     => esc_html__('Spacing', 'makbet'),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Step
        $this->add_control(
            'step_heading',
            [
                'label'     => esc_html__('Step', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'step_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-number' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'step_stroke_width',
            [
                'label'     => __('Stroke Width', 'makbet'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-number svg text' => 'stroke-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Title
        $this->add_control(
            'step_title_heading',
            [
                'label'     => esc_html__('Title', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'step_title_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'step_title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'step_title_typo',
                'selector' => '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-title',
            ]
        );

        // Desc
        $this->add_control(
            'step_desc_heading',
            [
                'label'     => esc_html__('Description', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'step_desc_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'step_desc_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'step_desc_typo',
                'selector' => '{{WRAPPER}} .elementor-step-wrapper .elementor-step-item .step-content',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper', 'class', ['elementor-step-wrapper']);
        // Item
        $this->add_render_attribute('item', 'class', 'elementor-step-item');

        ?>

        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <?php foreach ($settings['step'] as $item) { ?>
                <div <?php $this->print_render_attribute_string('item'); ?> data-rotate="<?php echo esc_attr($item['step_rotate']); ?>">

                    <?php if (!empty($item['step_number'])) { ?>
                        <span class="step-number">
                            <?php
                            $randomNumber = rand(1000, 9999);
                            $stroke       = 'gradient-stroke-' . $randomNumber;
                            ?>

                            <style>
                                 .elementor-step-wrapper .elementor-step-item:hover svg text {
                                     fill: url(#<?php echo esc_attr($stroke); ?>);
                                 }
                            </style>

                            <svg xmlns="http://www.w3.org/2000/svg" class="svg-gradient-text">
                                <defs>
                                    <linearGradient id="<?php echo esc_attr($stroke); ?>" x1="0%" y1="0%" x2="100%" y2="0%">
                                        <stop offset="0%" stop-color="#FF5B46"/>
                                        <stop offset="100%" stop-color="#3A3CF2"/>
                                    </linearGradient>
                                </defs>

                                <text x="0" y="0" style="stroke: url(#<?php echo esc_attr($stroke); ?>);">
                                    <?php echo esc_html($item['step_number']); ?>
                                </text>
                            </svg>

                        </span>
                    <?php } ?>

                    <div class="step-content-wrapper">
                        <?php if (!empty($item['step_title'])) { ?>
                            <span class="step-title"><?php echo esc_html($item['step_title']); ?></span>
                        <?php } ?>

                        <?php if (!empty($item['step_content'])) { ?>
                            <span class="step-content"><?php echo esc_html($item['step_content']); ?></span>
                        <?php } ?>
                    </div>

                </div>
            <?php } ?>
        </div>
        <?php
        wp_reset_postdata();
    }

}

$widgets_manager->register(new Makbet_Elementor_Step());