<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Group_Control_Background;


class Makbet_Elementor_Slider_Scrolling extends Makbet_Base_Widgets {

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @return string Widget name.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'makbet-slider-scrolling';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @return string Widget title.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__('Makbet Slider Scrolling', 'makbet');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-image';
    }

    public function get_script_depends() {
        return ['makbet-elementor-slider-scrolling'];
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_slider_scrolling',
            [
                'label' => esc_html__('Slider Scrolling', 'makbet'),
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
            'scrolling_title',
            [
                'label'   => esc_html__('Title 1', 'makbet'),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Scrolling title',
            ]
        );
        $repeater->add_control(
            'scrolling_title_link',
            [
                'label'       => esc_html__('Link to', 'makbet'),
                'placeholder' => esc_html__('https://your-link.com', 'makbet'),
                'type'        => Controls_Manager::URL,
            ]
        );
        $this->add_control(
            'slider_scrolling',
            [
                'label'       => esc_html__('Items', 'makbet'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ scrolling_title }}}',
            ]
        );

        $this->add_control(
            'effects_scrolling',
            [
                'label' => esc_html__('Effects Scrolling', 'makbet'),
                'type'  => Controls_Manager::SWITCHER,
                'prefix_class' => 'scrolling-effects-',

            ]
        );
        $this->add_control(
            'scrolling_layout',
            [
                'label'        => esc_html__('Layout', 'makbet'),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'default',
                'options'      => [
                    'default' => esc_html__('Default', 'makbet'),
                    '1'       => esc_html__('Layout 1', 'makbet'),
                ],
                'prefix_class' => 'scroll-layout-style-',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_slider_scrolling_wrapper',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'slider_scrolling_padding',
            [
                'label' => esc_html__('Padding', 'makbet'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-scrolling-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slider_scrolling_margin',
            [
                'label' => esc_html__('Margin', 'makbet'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-scrolling-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slider_scrolling_background_color',
            [
                'label' => esc_html__('Background Color', 'makbet'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-scrolling-item-wrapper' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_slider_scrolling_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'slider_scrollingtitle_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-slider-scrolling-inner .elementor-slider-scrolling-item .elementor-scrolling-item-inner .scrolling-title .title-scrolling a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-slider-scrolling-inner .elementor-slider-scrolling-item .elementor-scrolling-item-inner .scrolling-title .title-scrolling' => 'color: {{VALUE}};',
                ],
                'condition'      => [
                    'scrolling_layout' => '1',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .elementor-slider-scrolling-inner .elementor-slider-scrolling-item .elementor-scrolling-item-inner .scrolling-title .title-scrolling',
            ]
        );

        $this->add_responsive_control(
            'slider_scrolling_title_margin',
            [
                'label'      => esc_html__('Margin', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-slider-scrolling-inner .elementor-slider-scrolling-item .elementor-scrolling-item-inner .scrolling-title ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            'slider_scrolling_time',
            [
                'label'      => esc_html__('Time scroll', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 's',
                ],
                'range'      => [
                    's' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['s', 'ms'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-slider-scrolling-item-wrapper .elementor-slider-scrolling-inner' => 'animation-duration: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this -> add_control(
            'slider_scrolling_direct',
            [
                'label'    => __('Direct', 'makbet'),
                'type'     => Controls_Manager::SELECT2,
                'default'  => 'rtl',
                'options'  => [
                    'rtl' => __('RTL', 'makbet'),
                    'ltr' => __('LTR', 'makbet'),
                ],
                'multiple' => false,
                'prefix_class' => 'slider-'
            ]
        );
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['slider_scrolling']) && is_array($settings['slider_scrolling'])) {
            $this->add_render_attribute('wrapper', 'class', 'elementor-slider-scrolling-item-wrapper');
            $this->add_render_attribute('inner', 'class', 'elementor-slider-scrolling-inner');
            $this->add_render_attribute('item', 'class', 'elementor-slider-scrolling-item');
            ?>
            <div <?php $this->print_render_attribute_string('wrapper'); ?>>
                <div class="wrapper-item">
                    <?php for ($i = 0; $i <= 3; $i++) : ?>
                        <div <?php $this->print_render_attribute_string('inner'); ?>>
                            <?php foreach ($settings['slider_scrolling'] as $item) : ?>
                                <div <?php $this->print_render_attribute_string('item'); ?>>
                                    <div class="elementor-scrolling-item-inner">
                                        <div class="scrolling-title">
                                            <?php
                                            $scrolling_title_html = $item['scrolling_title'];
                                            if (!empty($item['scrolling_title_link']['url'])) {
                                                $scrolling_title_html = '<a href="' . esc_url($item['scrolling_title_link']['url']) . '">' . esc_html($scrolling_title_html) . '</a>';
                                            }
                                            printf('<span class="title-scrolling">%s</span>', $scrolling_title_html);
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endfor; ?>
                </div>
            </div>
            <?php
        }
    }

}
$widgets_manager->register(new Makbet_Elementor_Slider_Scrolling());