<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Makbet\Elementor\Makbet_Base_Widgets;


class Makbet_Elementor_Process extends Makbet_Base_Widgets {

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @return string Widget name.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'makbet-process';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @return string Widget title.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__('Makbet Process', 'makbet');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-archive';
    }

    public function get_script_depends() {
        return ['makbet-elementor-process'];
    }

    public function get_style_depends() {
        return ['e-swiper'];
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_process',
            [
                'label' => esc_html__('Item', 'makbet'),

            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'process_image',
            [
                'label'      => esc_html__('Choose Image', 'makbet'),
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );

        $repeater->add_control(
            'process_title',
            [
                'label'   => esc_html__('Title', 'makbet'),
                'default' => 'Discovery & Strategy',
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'process_content',
            [
                'label'       => esc_html__('Content', 'makbet'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
                'label_block' => true,
                'rows'        => '6',
            ]
        );
        $this->add_control(
            'process',
            [
                'label'       => esc_html__('Items', 'makbet'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ process_title }}}',
            ]
        );
        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name'      => 'process_image',
                'default'   => 'full',
                'separator' => 'none',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_process',
            [
                'label' => esc_html__('Box', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'process_background',
            [
                'label'     => esc_html__('Background Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius_process',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_process',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_testimonial_img',
            [
                'label' => esc_html__('Image', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_gap',
            [
                'label'      => esc_html__('Gap', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content' => 'Gap: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'testimonial_width_img',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content .elementor-process-image'           => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_height_img',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content .elementor-process-image' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'testimonial_radius_img',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content .elementor-process-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_process_img',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_process_title',
            [
                'label' => esc_html__('Title', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'process_title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .title-number .process-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'process_title_typography',
                'selector' => '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .title-number .process-title',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_process_content',
            [
                'label' => esc_html__('Content', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'process_content_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content .process-content' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'process_content_typography',
                'selector' => '{{WRAPPER}} .elementor-process-wrapper .elementor-process-item .image-content .process-content',
            ]
        );
        $this->end_controls_section();

        $this->get_controls_column();
        // Carousel options
        $this->get_control_carousel();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        if (!empty($settings['process']) && is_array($settings['process'])) {
            $this->add_render_attribute('wrapper', 'class', 'elementor-process-wrapper');
            $this->get_data_elementor_columns();
            $this->add_render_attribute('container', 'data-count', count($settings['process']));
            $this->add_render_attribute('item', 'class', 'elementor-grid-item elementor-process-item');
            $number            = 0;

            ?>
            <div <?php $this->print_render_attribute_string('wrapper'); ?>>
                <div <?php $this->print_render_attribute_string('container'); ?>>
                    <div <?php $this->print_render_attribute_string('inner'); ?>>
                        <?php foreach ($settings['process'] as $item):
                            $number++;
                            ?>
                            <div <?php $this->print_render_attribute_string('item'); ?>>
                                <div class="image-content">
                                    <?php $this->render_image($settings, $item); ?>
                                    <?php if (!empty($item['process_content'])) : ?>
                                        <div class="process-content"><?php echo sprintf('%s', $item['process_content']); ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="title-number">
                                    <?php if (!empty($item['process_title'])) : ?>
                                        <div class="process-title"><?php echo sprintf('%s', $item['process_title']); ?></div>
                                    <?php endif; ?>
                                    <div class="entry-number">
                                        <span class="number" data-text="<?php echo sprintf("%02d", $number); ?>">
                                            <?php
                                            $randomNumber = rand(1000, 9999);
                                            $stroke = 'gradient-stroke-'.$randomNumber;
                                            ?>

                                            <style>
                                                 .elementor-widget-makbet-process .elementor-process-wrapper .elementor-process-item:hover .title-number .number svg text {
                                                     fill: url(#<?php echo esc_attr($stroke); ?>);
                                                 }
                                            </style>

                                            <svg xmlns="http://www.w3.org/2000/svg" class="svg-gradient-text">
                                                <defs>
                                                    <linearGradient id="<?php echo esc_attr($stroke); ?>" x1="0%" y1="0%" x2="100%" y2="0%">
                                                        <stop offset="0%" stop-color="#FF5B46"/>
                                                        <stop offset="100%" stop-color="#3A3CF2"/>
                                                    </linearGradient>
                                                </defs>

                                                <text x="0" y="0" style="stroke: url(#<?php echo esc_attr($stroke); ?>);">
                                                    <?php echo sprintf("%02d", $number); ?>
                                                </text>
                                            </svg>
                                        </span>
                                    </div>

                                </div>

                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php $this->get_swiper_navigation(count($settings['process'])); ?>

                </div>
            </div>
            <?php
        }
    }
    private function render_image($settings, $item) {
        if (!empty($item['process_image']['url'])) :
            ?>
            <div class="elementor-process-image">
                <?php
                $item['process_image_size']             = $settings['process_image_size'];
                $item['process_image_custom_dimension'] = $settings['process_image_custom_dimension'];
                echo Group_Control_Image_Size::get_attachment_image_html($item, 'process_image');
                ?>
            </div>
        <?php
        endif;
    }
}
$widgets_manager->register(new Makbet_Elementor_Process());
