<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Makbet_Elementor_Post_type_Nav extends Elementor\Widget_Base {

    public function get_name() {
        return 'makbet-post_type-nav';
    }

    public function get_title() {
        return esc_html__('Makbet Single Post Type Navigation', 'makbet');
    }

    public function get_icon() {
        return 'eicon-post-navigation';
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    public function render() {

        $obj        = $this->makbet_get_post_link();
        $prev_link  = $obj->previous_post;
        $next_link  = $obj->next_post;
        $prev_title = $obj->previous_title;
        $next_title = $obj->next_title;
        $prev_thumb = $obj->previous_thumb;
        $next_thumb = $obj->next_thumb;

        $settings = $this->get_settings_for_display();

        if (!empty($prev_link) || !empty($next_link)):
            ?>
            <div class="single-post_type-navigation single-navigation">
                <?php if (!empty($prev_link)): ?>
                    <div class="nav-prev">
                        <a class="button-post_type-nav" href="<?php echo esc_url($prev_link); ?>">
                            <?php if ($settings['show_thumbnail'] === 'yes' && $prev_thumb): ?>
                                <span class="thumb">
                                    <img src="<?php echo esc_url($prev_thumb); ?>" alt="<?php echo esc_attr($prev_title); ?>">
                                </span>
                            <?php endif; ?>
                            <span class="content">
                                <?php if ($settings['icon']) { ?>
                                    <span class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon($settings['prev_icon'], ['aria-hidden' => 'true']); ?>
                                    </span>
                                <?php } ?>
                                <?php if ($settings['text']) { ?>
                                    <span class="reader-text"><?php echo esc_html($settings['prev_text']) ?></span>
                                <?php } ?>
                                <?php if ($settings['name_post_type']) { ?>
                                    <span class="title"><?php echo esc_html($prev_title) ?></span>
                                <?php } ?>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>

                <?php if (!empty($next_link)): ?>
                    <div class="nav-next">
                        <a class="button-post_type-nav" href="<?php echo esc_url($next_link); ?>">
                            <span class="content">
                                <?php if ($settings['text']) { ?>
                                    <span class="reader-text"><?php echo esc_html($settings['next_text']) ?></span>
                                <?php } ?>
                                <?php if ($settings['icon']) { ?>
                                    <span class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon($settings['next_icon'], ['aria-hidden' => 'true']); ?>
                                    </span>
                                <?php } ?>
                                <?php if ($settings['name_post_type']) { ?>
                                    <span class="title"><?php echo esc_html($next_title) ?></span>
                                <?php } ?>
                            </span>

                            <?php if ($settings['show_thumbnail'] === 'yes' && $next_thumb): ?>
                                <span class="thumb">
                                        <img src="<?php echo esc_url($next_thumb); ?>" alt="<?php echo esc_attr($next_title); ?>">
                                    </span>
                            <?php endif; ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif;
    }

    public function makbet_get_post_link($taxonomy = '', $post_type = '') {

        $id        = get_queried_object_id();
        $post      = get_post($id);
        $post_type = $post->post_type;

        $links = [
            'previous_post'  => null,
            'previous_title' => null,
            'next_post'      => null,
            'next_title'     => null,
            'previous_thumb' => null,
            'next_thumb'     => null
        ];

        $post_args = [
            'post_type'      => $post_type,
            'fields'         => 'ids',
            'posts_per_page' => -1,
            'orderby'        => 'date',
            'order'          => 'DESC'
        ];

        $q                     = get_posts($post_args);
        $current_post_position = array_search($id, $q);

        if (array_key_exists($current_post_position + 1, $q)) {
            $previous                = $q[$current_post_position + 1];
            $previous_post           = get_post($previous);
            $links['previous_post']  = get_permalink($previous);
            $links['previous_title'] = $previous_post->post_title;
            $links['previous_thumb'] = get_the_post_thumbnail_url($previous, 'full');
        }

        if (array_key_exists($current_post_position - 1, $q)) {
            $next                = $q[$current_post_position - 1];
            $next_post           = get_post($next);
            $links['next_post']  = get_permalink($next);
            $links['next_title'] = $next_post->post_title;
            $links['next_thumb'] = get_the_post_thumbnail_url($next, 'full');
        }

        return (object)$links;
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => esc_html__('Single Product Nav', 'makbet'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_thumbnail',
            [
                'label'   => esc_html__('Display Thumbnail', 'makbet'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'text',
            [
                'label'   => esc_html__('Display Text', 'makbet'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'prev_text',
            [
                'label'     => esc_html__('Previous Text', 'makbet'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Previous Project', 'makbet'),
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'next_text',
            [
                'label'     => esc_html__('Next Text', 'makbet'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Next Project', 'makbet'),
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'name_post_type',
            [
                'label'   => esc_html__('Display Name', 'makbet'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'icon',
            [
                'label'   => esc_html__('Display Icon', 'makbet'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label'     => esc_html__('Previous Icon', 'makbet'),
                'type'      => Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'next_icon',
            [
                'label'     => esc_html__('Next Icon', 'makbet'),
                'type'      => Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-angle-right',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'icon' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Wrapper
        $this->start_controls_section(
            'section_style_wrapper',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'nav_padding',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .single-post_type-navigation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_gap',
            [
                'label'      => esc_html__('Gap', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .single-post_type-navigation .button-post_type-nav' => 'gap: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        // Image
        $this->start_controls_section(
            'section_style_image',
            [
                'label'     => esc_html__('Image', 'makbet'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'style_image_height',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .single-post_type-navigation .thumb' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'style_image_width',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .single-post_type-navigation .thumb' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'style_image_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .single-post_type-navigation .thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'space_between_widgets',
            [
                'label'       => esc_html__('Gaps', 'makbet'),
                'type'        => Controls_Manager::GAPS,
                'default'     => [
                    'row'    => '10',
                    'column' => '10',
                    'unit'   => 'px',
                ],
                'size_units'  => ['px', 'em', 'rem'],
                'placeholder' => [
                    'row'    => '10',
                    'column' => '10',
                ],
                'selectors'   => [
                    '{{WRAPPER}} .content' => 'gap: {{ROW}}{{UNIT}} {{COLUMN}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'icon_heading',
            [
                'label'     => esc_html__('Icon', 'makbet'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'icon' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'      => esc_html__('Size', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .icon i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
                'condition'  => [
                    'icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'icon' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'text_heading',
            [
                'label'     => esc_html__('Text', 'makbet'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .reader-text' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'text_typography',
                'selector'  => '{{WRAPPER}} .reader-text',
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'name_heading',
            [
                'label'     => esc_html__('Name', 'makbet'),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'name_post_type' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'name_typography',
                'selector'  => '{{WRAPPER}} .title',
                'condition' => [
                    'text' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }
}

$widgets_manager->register(new Makbet_Elementor_Post_type_Nav());
