<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Makbet\Elementor\Makbet_Base_Widgets;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Background;


class Makbet_Elementor_Award_Winning extends Makbet_Base_Widgets {

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @return string Widget name.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'makbet-award-winning';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @return string Widget title.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__('Makbet Award Winning', 'makbet');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_script_depends() {
        return ['makbet-elementor-award-winning'];
    }

    public function get_style_depends() {
        return ['e-swiper'];
    }

    public function get_categories() {
        return array('makbet-addons');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_award_winning',
            [
                'label' => esc_html__('Item', 'makbet'),
            ]
        );
        $this->add_control(
            'award_image',
            [
                'label'      => esc_html__('Choose Image', 'makbet'),
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );
        $this->add_control(
            'award_winning_year',
            [
                'label'   => esc_html__('Year', 'makbet'),
                'default' => '2021',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'award_winning_title',
            [
                'label'   => esc_html__('Title', 'makbet'),
                'default' => 'The Webby Awards',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'award_winning_subtitle',
            [
                'label'   => esc_html__('Subtitle', 'makbet'),
                'default' => 'Digital marketing campaigns, websites, social media, and online video',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'award_image_second',
            [
                'label'      => esc_html__('Choose Image', 'makbet'),
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false,
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_award',
            [
                'label' => esc_html__('Wrapper', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'award_wrapper_gap',
            [
                'label'      => esc_html__('Gap', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper' => 'Gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'  => 'background_winning_color',
                'types' => [ 'gradient' ],
                'fields_options' => [
                    'background' => [
                        'label'               => __( 'Background Gradient', 'makbet' ),
                        'frontend_available'  => true,
                    ],
                ],
                'selector'  => '{{WRAPPER}} .award-winning-wrapper',
            ]
        );
        $this->add_control(
            'border_radius_award',
            [
                'label'      => esc_html__('Border Radius', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding_award',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_award_caption',
            [
                'label' => esc_html__('Caption', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'award_width_caption',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-caption'           => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'award_heading_title',
            [
                'label'     => esc_html__('Title', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'award_title_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .award-winning-wrapper .award-caption .award-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'award_title_typography',
                'selector' => '{{WRAPPER}} .award-winning-wrapper .award-caption .award-title',
            ]
        );
        $this->add_responsive_control(
            'award_title_spacing',
            [
                'label'      => esc_html__('Padding', 'makbet'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-caption .award-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'award_heading_subtitle',
            [
                'label'     => esc_html__('SubTitle', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'award_subtitle_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .award-winning-wrapper .award-caption .award-subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'award_subtitle_typography',
                'selector' => '{{WRAPPER}} .award-winning-wrapper .award-caption .award-subtitle',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_award_img',
            [
                'label' => esc_html__('Image', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'award_image_gap',
            [
                'label'      => esc_html__('Gap', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-image' => 'Gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'award_heading_image',
            [
                'label'     => esc_html__('Image', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'award_width_img',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-image img'           => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'award_height_img',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-image img' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_control(
            'award__heading_image_second',
            [
                'label'     => esc_html__('Image Second', 'makbet'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'award_width_img_second',
            [
                'label'      => esc_html__('Width', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%', 'vw'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-image-second img'           => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'award_height_img_second',
            [
                'label'      => esc_html__('Height', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'vh', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-image-second img' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_year',
            [
                'label' => esc_html__('Year', 'makbet'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'award_year_color',
            [
                'label'     => esc_html__('Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .award-winning-wrapper .award-year' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Stroke::get_type(),
            [
                'name'     => 'text_stroke',
                'selector' => '{{WRAPPER}} .award-winning-wrapper .award-year',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'award_year_typography',
                'selector' => '{{WRAPPER}} .award-winning-wrapper .award-year',
            ]
        );
        $this->add_responsive_control(
            'award_padding_award_winning_img',
            [
                'label'      => esc_html__('Right', 'makbet'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range'      => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .award-winning-wrapper .award-year' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
            $this->add_render_attribute('wrapper', 'class', 'award-winning-wrapper');
            ?>
                <div <?php $this->print_render_attribute_string('wrapper'); ?>>
                    <?php if (!empty($settings['award_image']['url'])): ?>
                        <div class="award-image">
                            <img src="<?php echo esc_url($settings['award_image']['url']); ?>" alt="<?php echo esc_attr__('Award Image', 'makbet'); ?>">
                        </div>
                    <?php endif; ?>

                    <div class="award-caption">
                        <?php if ($settings['award_winning_title']): ?>
                            <span class="award-title"><?php echo esc_html($settings['award_winning_title']); ?></span>
                        <?php endif; ?>
                        <?php if ($settings['award_winning_subtitle']): ?>
                            <span class="award-subtitle"><?php echo esc_html($settings['award_winning_subtitle']); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty($settings['award_image_second']['url'])): ?>
                        <div class="award-image-second">
                            <img src="<?php echo esc_url($settings['award_image_second']['url']); ?>" alt="<?php echo esc_attr__('Award Image', 'makbet'); ?>">
                        </div>
                    <?php endif; ?>
                    <?php if ($settings['award_winning_year']): ?>
                        <span class="award-year"><?php echo esc_html($settings['award_winning_year']); ?></span>
                    <?php endif; ?>
                </div>
            <?php
    }
}
$widgets_manager->register(new Makbet_Elementor_Award_Winning());
