<?php
// Image Box
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;

add_action('elementor/element/image-box/section_image/before_section_end', function ($element, $args) {
    $element->add_control(
        'image_box_effects',
        [
            'label'     => esc_html__('Effects Img', 'makbet'),
            'type'      => Controls_Manager::SWITCHER,
            'default'   => 'no',
            'prefix_class' => 'effects-img-box-',

        ]
    );
}, 10, 2);

add_action('elementor/element/image-box/section_style_image/before_section_end', function ($element, $args) {
    $element->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name'     => 'box_shadow',
            'selector' => '{{WRAPPER}} .elementor-image-box-img img',
        ]
    );
}, 10, 2);

add_action('elementor/element/image-box/section_style_content/before_section_end', function ($element, $args) {
    $element->add_group_control(
        Group_Control_Border::get_type(),
        [
            'name'        => 'wrapper_border',
            'placeholder' => '1px',
            'default'     => '1px',
            'selector'    => '{{WRAPPER}} .elementor-image-box-description',
            'separator'   => 'before',
        ]
    );
    $element->add_responsive_control(
        'padding_image_box_des',
        [
            'label'      => esc_html__('Padding', 'makbet'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .elementor-image-box-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $element->add_responsive_control(
        'margin_image_box_des',
        [
            'label'      => esc_html__('Margin', 'makbet'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .elementor-image-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
}, 10, 2);