<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
add_action('elementor/element/heading/section_title/before_section_end', function ($element, $args) {
    $element->add_control(
        'effect_heading',
        [
            'label'        => esc_html__('Effect Heading', 'makbet'),
            'type'         => Controls_Manager::SWITCHER,
            'default'      => 'no',
            'prefix_class' => 'heading-effect-',
        ]
    );
}, 10, 2);

add_action('elementor/element/heading/section_title_style/before_section_end', function ($element, $args) {
    $default_args = [
        'section_condition' => [],
    ];

    $element->update_control( 'title_colors_normal', [
        'condition' => [
            'heading_text_gradient!' => 'yes',
        ],
    ] );
    $element->update_control( 'title_color', [
        'condition' => [
            'heading_text_gradient!' => 'yes',
        ],
    ] );
    $element->update_control( 'title_colors_hover', [
        'condition' => [
            'heading_text_gradient!' => 'yes',
        ],
    ] );
    $element->update_control( 'title_hover_color', [
        'condition' => [
            'heading_text_gradient!' => 'yes',
        ],
    ] );
    $element->add_control(
        'heading_text_gradient',
        [
            'label' => esc_html__('Gradient', 'makbet'),
            'type'  => Controls_Manager::SWITCHER,

            'prefix_class' => 'heading-text-gradient-'
        ]
    );
    $element->add_group_control(
        Group_Control_Background::get_type(),
        [
            'name'           => 'overlay_color_text',
            'types'          => ['gradient'],
            'fields_options' => [
                'background' => [
                    'label'               => __( 'Gradient Color', 'makbet' ),
                    'frontend_available'  => true,
                ],
            ],
            'selector'       => '{{WRAPPER}}.heading-text-gradient-yes .elementor-heading-title ',
            'condition'      => [
                'heading_text_gradient' => 'yes',
            ],
        ]
    );
}, 10, 2);