<?php
// Button
use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;

add_action('elementor/element/button/section_button/after_section_end', function ($element, $args) {
    $default_args = [
        'section_condition' => [],
    ];

    $args = wp_parse_args( $args, $default_args );
    $element->update_control(
        'button_type',
        [
            'label'        => esc_html__('Type', 'makbet'),
            'type'         => Controls_Manager::SELECT,
            'default'      => 'default',
            'options'      => [
                'default' => esc_html__('Default', 'makbet'),
                'outline' => esc_html__('OutLine', 'makbet'),
                'info'    => esc_html__('Info', 'makbet'),
                'success' => esc_html__('Success', 'makbet'),
                'warning' => esc_html__('Warning', 'makbet'),
                'danger'  => esc_html__('Danger', 'makbet'),
                'link'    => esc_html__('Link', 'makbet'),
                'bgEffect'    => esc_html__('Gradient', 'makbet'),

            ],
            'prefix_class' => 'elementor-button-',
        ]
    );

    $element->update_control(
        'size',
        [
            'condition' => array_merge( $args['section_condition'], [ 'size[value]!' => '' ] ),
        ]
    );
    $element->update_control(
        'icon_align',
        [
            'condition' => array_merge($args['section_condition'], ['icon_button_effects!' => 'yes', 'selected_icon[value]!' => '']),
        ]
    );
}, 10, 2);

add_action('elementor/element/button/section_button/before_section_end', function ($element, $args) {

    $element->add_responsive_control(
        'icon_button_size',
        [
            'label'        => esc_html__('Icon size', 'makbet'),
            'type'      => Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
            'default' => [
                'size' => 16,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button-content-wrapper .elementor-button-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .elementor-button-content-wrapper .elementor-button-icon svg' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
    $element->add_control(
        'icon_button_effects',
        [
            'label'     => esc_html__('Effects Button', 'makbet'),
            'type'      => Controls_Manager::SWITCHER,
            'default'   => 'no',
            'prefix_class' => 'enable-effects-',

        ]
    );
}, 10, 2);

add_action('elementor/element/button/section_style/before_section_end', function ($element, $args) {


    $default_args = [
        'section_condition' => [],
    ];
    $args = wp_parse_args( $args, $default_args );
    $element->update_control(
        'text_padding',
        [
            'condition' => array_merge($args['section_condition'], ['icon_button_effects!' => 'yes']),
        ]
    );
    $element->update_control( 'background_background', [
        'condition' => array_merge(
            $args['section_condition'],
            [ 'button_type!' => [ 'bgEffect', 'outline' ] ]
        ),
    ] );

    $element->update_control( 'background_color', [
        'condition' => array_merge(
            $args['section_condition'],
            [ 'button_type!' => [ 'bgEffect', 'outline' ] ]
        ),
    ] );
    $element->update_control( 'button_background_hover_background', [
        'condition' => array_merge(
            $args['section_condition'],
            [ 'button_type!' => [ 'bgEffect', 'outline' ] ]
        ),
    ] );

    $element->update_control( 'button_hover_border_color', [
        'condition' => [
            [ 'button_type!' => [ 'bgEffect', 'outline' ] ]
        ],
    ] );

    $element->update_control( 'button_background_hover_color', [

        'condition' => [
            'button_type!' => [ 'outline' ],
             'button_type' => [ 'default', 'info', 'success','warning', 'danger' ]

        ],
    ] );

    $element->add_responsive_control(
        'text_padding_effect',
        [
            'label' => esc_html__( 'Padding Effect', 'makbet' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
            'selectors' => [
                '{{WRAPPER}}.enable-effects-yes .elementor-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'separator' => 'before',
            'condition' => [
                'button_type!' => [ 'link' ],
                'icon_button_effects' => [ 'yes' ],
            ],
        ]
    );

    $element->add_control(
        'icon_button_background_color',
        [
            'label'     => esc_html__('Icon Background Color', 'makbet'),
            'type'      => Controls_Manager::COLOR,
            'condition' => [
                'selected_icon[value]!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button-content-wrapper .elementor-button-icon i' => 'background-color: {{VALUE}};',
                '{{WRAPPER}} .elementor-button-content-wrapper .elementor-button-icon svg' => 'background-color: {{VALUE}};',
            ],

        ]
    );
    $element->add_control(
            'icon_button_color',
            [
                'label'     => esc_html__('Icon Color', 'makbet'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'selected_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-button-content-wrapper .elementor-button-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-button-content-wrapper .elementor-button-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

    $element->add_control(
        'icon_button_color_hover',
        [
            'label'     => esc_html__('Icon Color Hover', 'makbet'),
            'type'      => Controls_Manager::COLOR,
            'condition' => [
                'selected_icon[value]!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button:hover .elementor-button-icon i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .elementor-button:hover .elementor-button-icon svg' => 'fill: {{VALUE}};',
                '{{WRAPPER}} .elementor-button:focus .elementor-button-icon i' => 'color: {{VALUE}};',
                '{{WRAPPER}} .elementor-button:focus .elementor-button-icon svg' => 'fill: {{VALUE}};',
            ],
        ]
    );
}, 10, 2);

