<?php

if (!class_exists('Pavo_CPT')) {
    return;
}
// create a service custom post type
$labels  = apply_filters('labels_pavo_service', array(
    'name'                  => esc_html__('Services', 'makbet'),
    'singular_name'         => esc_html__('Service', 'makbet'),
    'menu_name'             => esc_html__('Services', 'makbet'),
    'add_new'               => esc_html__('Add New', 'makbet'),
    'add_new_item'          => esc_html__('Add New Service', 'makbet'),
    'edit_item'             => esc_html__('Edit Service', 'makbet'),
    'new_item'              => esc_html__('New Service', 'makbet'),
    'view_item'             => esc_html__('View Service', 'makbet'),
    'view_items'            => esc_html__('View Services', 'makbet'),
    'search_items'          => esc_html__('Search Services', 'makbet'),
    'not_found'             => esc_html__('No Services found', 'makbet'),
    'not_found_in_trash'    => esc_html__('No Services found in Trash', 'makbet'),
    'parent_item_colon'     => esc_html__('Parent Service:', 'makbet'),
    'all_items'             => esc_html__('All Services', 'makbet'),
    'archives'              => esc_html__('Service Archives', 'makbet'),
    'attributes'            => esc_html__('Service Attributes', 'makbet'),
    'uploaded_to_this_item' => esc_html__('Uploaded to this Service', 'makbet'),
    'filter_items_list'     => esc_html__('Filter Services list', 'makbet'),
    'items_list_navigation' => esc_html__('Services list navigation', 'makbet'),
    'items_list'            => esc_html__('Services list', 'makbet'),
));
$service = new Pavo_CPT('pavo_service', array(
    'labels'      => $labels,
    'public'      => true,
    'has_archive' => true,
    'menu_icon'   => 'dashicons-admin-post',
    'supports'    => array('title', 'editor', 'thumbnail', 'excerpt'),
    'rewrite'     => array(
        'slug' => apply_filters('slug_pavo_service', 'services'),
    )
));

$labels = apply_filters('labels_pavo_service_taxonomy', array(
    'name'                       => esc_html__('Categories', 'makbet'),
    'singular_name'              => esc_html__('Category', 'makbet'),
    'menu_name'                  => esc_html__('Categories', 'makbet'),
    'all_items'                  => esc_html__('All Categories', 'makbet'),
    'edit_item'                  => esc_html__('Edit Category', 'makbet'),
    'view_item'                  => esc_html__('View Category', 'makbet'),
    'update_item'                => esc_html__('Update Category', 'makbet'),
    'add_new_item'               => esc_html__('Add New Category', 'makbet'),
    'new_item_name'              => esc_html__('New Category Name', 'makbet'),
    'parent_item'                => esc_html__('Parent Categories', 'makbet'),
    'parent_item_colon'          => esc_html__('Parent Categories:', 'makbet'),
    'search_items'               => esc_html__('Search Categories', 'makbet'),
    'popular_items'              => esc_html__('Popular Categories', 'makbet'),
    'separate_items_with_commas' => esc_html__('Seperate Categories with commas', 'makbet'),
    'add_or_remove_items'        => esc_html__('Add or remove Categories', 'makbet'),
    'choose_from_most_used'      => esc_html__('Choose from most used Categories', 'makbet'),
    'not_found'                  => esc_html__('No Categories found', 'makbet'),
));

$service->register_taxonomy('pavo_service_cat', array(
    'labels'       => $labels,
    'hierarchical' => true,
    'rewrite'      => array(
        'slug' => apply_filters('slug_pavo_service_cat', 'service_cat'),
    ),
));

add_action('cmb2_admin_init', 'create_meta_box_service');

function create_meta_box_service() {
    $cmb2 = new_cmb2_box(array(
        'id'           => 'service_metabox',
        'title'        => 'Service Info',
        'object_types' => array('pavo_service'),
    ));

    $cmb2->add_field(array(
        'name'        => 'Service Icon Image',
        'desc'        => 'Upload PNG/SVG icon to apply gradient color.',
        'id'          => 'service_icon',
        'type'        => 'file',
        'options'     => array(
            'url' => false,
        ),
        'text'        => array(
            'add_upload_file_text' => 'Add Icon',
        ),
        'query_args'  => array(
            'type' => array(
                'image/png',
                'image/gif',
                'image/svg+xml',
            ),
        ),
        'preview_size' => 'thumbnail',
    ));

    apply_filters('pavo_metabox_service_fields', $cmb2);
}


add_filter('body_class', 'service_body_classes', 31);
function service_body_classes($classes) {
    // Ensure the $classes variable is always an array
    if (!is_array($classes)) {
        $classes = [];
    }

    // Check if we're on a single communitie post, archive, or taxonomy page
    if (
        is_singular('pavo_service')
        || is_post_type_archive('pavo_service')
        || is_tax('pavo_service_cat')
    ) {
        // Remove layout-related classes to prevent default sidebar or layout behavior
        $classes = array_diff($classes, [
            'makbet-full-width-content',
            'makbet-sidebar-none',
            'makbet-sidebar-left',
            'makbet-sidebar-right'
        ]);
    }

    // Return the modified body class array
    return $classes;
}

add_filter('pavo_theme_sidebar', 'service_set_sidebar', 20);
function service_set_sidebar($name) {
    if (
        is_singular('pavo_service')
        || (is_post_type_archive('pavo_service') || is_tax('pavo_service_cat'))
           && (is_archive() || is_home() || is_category() || is_tag() || is_author() || is_search())
    ) {
        return '';
    }

    return $name;
}