<?php

if (!class_exists('Pavo_CPT')) {
    return;
}

// create a portfolio custom post type
$labels = apply_filters('labels_pavo_portfolio', array(
    'name'                  => esc_html__('Portfolios', 'makbet'),
    'singular_name'         => esc_html__('Portfolio', 'makbet'),
    'menu_name'             => esc_html__('Portfolios', 'makbet'),
    'add_new'               => esc_html__('Add New', 'makbet'),
    'add_new_item'          => esc_html__('Add New Portfolio', 'makbet'),
    'edit_item'             => esc_html__('Edit Portfolio', 'makbet'),
    'new_item'              => esc_html__('New Portfolio', 'makbet'),
    'view_item'             => esc_html__('View Portfolio', 'makbet'),
    'view_items'            => esc_html__('View Portfolios', 'makbet'),
    'search_items'          => esc_html__('Search Portfolios', 'makbet'),
    'not_found'             => esc_html__('No Portfolios found', 'makbet'),
    'not_found_in_trash'    => esc_html__('No Portfolios found in Trash', 'makbet'),
    'parent_item_colon'     => esc_html__('Parent Portfolio:', 'makbet'),
    'all_items'             => esc_html__('All Portfolios', 'makbet'),
    'archives'              => esc_html__('Portfolio Archives', 'makbet'),
    'attributes'            => esc_html__('Portfolio Attributes', 'makbet'),
    'uploaded_to_this_item' => esc_html__('Uploaded to this Portfolio', 'makbet'),
    'filter_items_list'     => esc_html__('Filter Portfolios list', 'makbet'),
    'items_list_navigation' => esc_html__('Portfolios list navigation', 'makbet'),
    'items_list'            => esc_html__('Portfolios list', 'makbet'),
));


$portfolio = new Pavo_CPT('pavo_portfolio', array(
    'labels'      => $labels,
    'public'      => true,
    'has_archive' => true,
    'menu_icon'   => 'dashicons-portfolio',
    'supports'    => array('title', 'editor', 'thumbnail', 'excerpt'),
    'rewrite'     => array(
        'slug' => apply_filters('slug_pavo_portfolio', 'portfolios'),
    )
));

// create a genre taxonomy
// Default labels.
$labels = apply_filters('labels_pavo_portfolio_taxonomy', array(
    'name'                       => esc_html__('Categories', 'makbet'),
    'singular_name'              => esc_html__('Category', 'makbet'),
    'menu_name'                  => esc_html__('Categories', 'makbet'),
    'all_items'                  => esc_html__('All Categories', 'makbet'),
    'edit_item'                  => esc_html__('Edit Category', 'makbet'),
    'view_item'                  => esc_html__('View Category', 'makbet'),
    'update_item'                => esc_html__('Update Category', 'makbet'),
    'add_new_item'               => esc_html__('Add New Category', 'makbet'),
    'new_item_name'              => esc_html__('New Category Name', 'makbet'),
    'parent_item'                => esc_html__('Parent Categories', 'makbet'),
    'parent_item_colon'          => esc_html__('Parent Categories:', 'makbet'),
    'search_items'               => esc_html__('Search Categories', 'makbet'),
    'popular_items'              => esc_html__('Popular Categories', 'makbet'),
    'separate_items_with_commas' => esc_html__('Seperate Categories with commas', 'makbet'),
    'add_or_remove_items'        => esc_html__('Add or remove Categories', 'makbet'),
    'choose_from_most_used'      => esc_html__('Choose from most used Categories', 'makbet'),
    'not_found'                  => esc_html__('No Categories found', 'makbet'),
));

$portfolio->register_taxonomy('pavo_portfolio_cat', array(
    'labels'       => $labels,
    'hierarchical' => true,
    'rewrite'      => array(
        'slug' => apply_filters('slug_pavo_portfolio_cat', 'portfolio_cat'),
    ),
    //    'meta_box_cb'  => false,
));


add_filter('body_class', 'portfolio_body_classes', 31);
function portfolio_body_classes($classes) {
    if (is_singular('pavo_portfolio') || is_post_type_archive('pavo_portfolio') || is_tax('pavo_portfolio_cat')) {
        $classes = array_diff($classes, array(
            'makbet-full-width-content',
            'makbet-sidebar-none',
            'makbet-sidebar-left',
            'makbet-sidebar-right'
        ));
    }
    return $classes;
}

add_action('cmb2_admin_init', 'create_meta_box_portfolio');
function create_meta_box_portfolio() {
    $cmb2 = new_cmb2_box(array(
        'id'           => 'makbet_video_portfolio_setting',
        'title'        => __('Video Settings', 'makbet'),
        'object_types' => array('pavo_portfolio'),
    ));

    $cmb2->add_field(array(
        'name'         => __('Upload Video', 'makbet'),
        'desc'         => __('Upload video file or choose from media library (mp4, avi, mov, wmv, webm, mkv).', 'makbet'),
        'id'           => 'video_portfolio_file',
        'type'         => 'file',
        'options'      => array(
            'url' => true,
        ),
        'text'         => array(
            'add_upload_file_text' => __('Add Video', 'makbet'),
        ),
        'query_args'   => array(
            'type' => array(
                'video/mp4',    // MP4
                'video/avi',    // AVI
                'video/mov',    // MOV
                'video/wmv',    // WMV
                'video/webm',   // WebM
                'video/mkv'     // MKV
            ),
        ),
        'preview_size' => 'medium',
    ));
}