<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Makbet_Customize')) {

    class Makbet_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        public function get_product_extra_template() {
            global $post;

            $options[''] = esc_html__('Select Template', 'makbet');
            if (!makbet_is_elementor_activated()) {
                return;
            }
            $args = array(
                'post_type'      => 'elementor_library',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                's'              => 'Product',
                'order'          => 'ASC',
            );

            $query1 = new WP_Query($args);
            while ($query1->have_posts()) {
                $query1->the_post();
                $options[$post->post_name] = $post->post_title;
            }

            wp_reset_postdata();
            return $options;
        }

        public function get_contact_forms() {
            $cf7               = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');
            $contact_forms[''] = esc_html__('Please select form', 'makbet');
            if ($cf7) {
                foreach ($cf7 as $cform) {
                    $contact_forms[$cform->ID] = $cform->post_title;
                }
            } else {
                $contact_forms[0] = esc_html__('No contact forms found', 'makbet');
            }
            return $contact_forms;
        }

        public function customize_register($wp_customize) {
            /**
             * Theme options.
             */
            $this->init_makbet_blog($wp_customize);
            $this->makbet_register_theme_customizer($wp_customize);
            if (makbet_is_woocommerce_activated()) {
                $this->init_woocommerce($wp_customize);
            }
            do_action('makbet_customize_register', $wp_customize);
        }

        function makbet_register_theme_customizer($wp_customize) {

        } // end makbet_register_theme_customizer

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_makbet_blog($wp_customize) {
            $wp_customize->add_setting(
                'page_for_404',
                array(
                    'type'              => 'option',
                    'capability'        => 'manage_options',
                    'sanitize_callback' => 'absint', // Ensure it's a valid integer
                )
            );

            $wp_customize->add_control(
                'page_for_404',
                array(
                    'label'          => esc_html__('404 page', 'makbet'),
                    'section'        => 'static_front_page',
                    'type'           => 'dropdown-pages',
                    'allow_addition' => true,
                )
            );

            $wp_customize->add_panel('makbet_blog', array(
                'title' => esc_html__('Blog', 'makbet'),
            ));

            // =========================================
            // Blog Archive
            // =========================================
            $wp_customize->add_section('makbet_blog_archive', array(
                'title'      => esc_html__('Archive', 'makbet'),
                'panel'      => 'makbet_blog',
                'capability' => 'edit_theme_options',
            ));

            $wp_customize->add_setting('makbet_options_blog_sidebar', array(
                'type'              => 'option',
                'default'           => 'right',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_sidebar', array(
                'section' => 'makbet_blog_archive',
                'label'   => esc_html__('Sidebar Position', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'none'  => esc_html__('None', 'makbet'),
                    'left'  => esc_html__('Left', 'makbet'),
                    'right' => esc_html__('Right', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_style', array(
                'section' => 'makbet_blog_archive',
                'label'   => esc_html__('Blog style', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'makbet'),
                    'grid'     => esc_html__('Blog Grid', 'makbet'),
                    'list'     => esc_html__('Blog List', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_blog_columns', array(
                'type'              => 'option',
                'default'           => 3,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_columns', array(
                'section' => 'makbet_blog_archive',
                'label'   => esc_html__('Colunms', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'makbet'),
                    2 => esc_html__('2', 'makbet'),
                    3 => esc_html__('3', 'makbet'),
                    4 => esc_html__('4', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_blog_columns_laptop', array(
                'type'              => 'option',
                'default'           => 3,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_columns_laptop', array(
                'section' => 'makbet_blog_archive',
                'label'   => esc_html__('Colunms Laptop', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'makbet'),
                    2 => esc_html__('2', 'makbet'),
                    3 => esc_html__('3', 'makbet'),
                    4 => esc_html__('4', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_blog_columns_tablet', array(
                'type'              => 'option',
                'default'           => 2,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_columns_tablet', array(
                'section' => 'makbet_blog_archive',
                'label'   => esc_html__('Colunms Tablet', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'makbet'),
                    2 => esc_html__('2', 'makbet'),
                    3 => esc_html__('3', 'makbet'),
                    4 => esc_html__('4', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_blog_columns_mobile', array(
                'type'              => 'option',
                'default'           => 1,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_columns_mobile', array(
                'section' => 'makbet_blog_archive',
                'label'   => esc_html__('Colunms Mobile', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'makbet'),
                    2 => esc_html__('2', 'makbet'),
                    3 => esc_html__('3', 'makbet'),
                    4 => esc_html__('4', 'makbet'),
                ),
            ));

            // =========================================
            // Blog Single
            // =========================================
            $wp_customize->add_section('makbet_blog_single', array(
                'title'      => esc_html__('Singular', 'makbet'),
                'panel'      => 'makbet_blog',
                'capability' => 'edit_theme_options',
            ));
            $wp_customize->add_setting('makbet_options_blog_single_sidebar', array(
                'type'              => 'option',
                'default'           => 'right',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_blog_single_sidebar', array(
                'section' => 'makbet_blog_single',
                'label'   => esc_html__('Sidebar Position', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'none'  => esc_html__('None', 'makbet'),
                    'left'  => esc_html__('Left', 'makbet'),
                    'right' => esc_html__('Right', 'makbet'),
                ),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */


        public function init_woocommerce($wp_customize) {

            $wp_customize->add_panel('woocommerce', array(
                'title' => esc_html__('Woocommerce', 'makbet'),
            ));

            $wp_customize->add_section('makbet_woocommerce_archive', array(
                'title'      => esc_html__('Archive', 'makbet'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('makbet_options_woocommerce_archive_content_width', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_woocommerce_archive_content_width', array(
                'section' => 'makbet_woocommerce_archive',
                'label'   => esc_html__('Content Width', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'default' => esc_html__('default', 'makbet'),
                    'wide'    => esc_html__('Wide', 'makbet'),

                ),
            ));

            $wp_customize->add_setting('makbet_options_woocommerce_archive_layout', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_woocommerce_archive_layout', array(
                'section' => 'makbet_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Sidebar', 'makbet'),
                    //====start_premium
                    'menu'     => esc_html__('Menu Filter', 'makbet'),
                    'drawing'  => esc_html__('Drawing Filter', 'makbet'),
                    'canvas'   => esc_html__('Canvas Filter', 'makbet'),
                    'dropdown' => esc_html__('Dropdown Filter', 'makbet'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('makbet_options_woocommerce_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_woocommerce_archive_sidebar', array(
                'section' => 'makbet_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'makbet'),
                    'right' => esc_html__('Right', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_woocommerce_shop_pagination', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_woocommerce_shop_pagination', array(
                'section' => 'makbet_woocommerce_archive',
                'label'   => esc_html__('Products pagination', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Pagination', 'makbet'),
                    'more-btn' => esc_html__('Load More', 'makbet'),
                    'infinit'  => esc_html__('Infinit Scroll', 'makbet'),
                ),
            ));

            // =========================================
            // Single Product
            // =========================================

            $wp_customize->add_section('makbet_woocommerce_single', array(
                'title'      => esc_html__('Singular', 'makbet'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('makbet_options_woocommerce_single_sidebar', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_woocommerce_single_sidebar', array(
                'section' => 'makbet_woocommerce_single',
                'label'   => esc_html__('Sidebar Position', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'default' => esc_html__('No Sidebar', 'makbet'),
                    'left'    => esc_html__('Left', 'makbet'),
                    'right'   => esc_html__('Right', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_single_product_gallery_layout', array(
                'type'              => 'option',
                'default'           => 'horizontal',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_single_product_gallery_layout', array(
                'section' => 'makbet_woocommerce_single',
                'label'   => esc_html__('Product Gallery Style', 'makbet'),
                'type'    => 'select',
                'choices' => array(
                    'horizontal' => esc_html__('Horizontal', 'makbet'),
                    'vertical'   => esc_html__('Vertical', 'makbet'),
                    'gallery'    => esc_html__('Gallery', 'makbet'),
                    'sticky'     => esc_html__('Sticky', 'makbet'),
                ),
            ));

            $wp_customize->add_setting('makbet_options_single_product_tabs_layout', array(
                'type'              => 'option',
                'default'           => 'tabs',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_single_product_tabs_layout', array(
                'section'         => 'makbet_woocommerce_single',
                'label'           => esc_html__('Product Tabs Style', 'makbet'),
                'type'            => 'select',
                'choices'         => array(
                    'tabs'         => esc_html__('Tabs', 'makbet'),
                    'full-content' => esc_html__('Full content', 'makbet'),
                    'accordion'    => esc_html__('Accordion', 'makbet'),
                ),
                'active_callback' => function ($control) {
                    $gallery_layout = $control->manager->get_setting('makbet_options_single_product_gallery_layout')->value();
                    return in_array($gallery_layout, array('horizontal', 'vertical', 'gallery'));
                },
            ));

            // =========================================
            // Product
            // =========================================

            $wp_customize->add_setting('makbet_options_wocommerce_row_laptop', array(
                'type'              => 'option',
                'default'           => 3,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_wocommerce_row_laptop', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row Laptop', 'makbet'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('makbet_options_wocommerce_row_tablet', array(
                'type'              => 'option',
                'default'           => 2,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_wocommerce_row_tablet', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row tablet', 'makbet'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('makbet_options_wocommerce_row_mobile_extra', array(
                'type'              => 'option',
                'default'           => 2,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_wocommerce_row_mobile_extra', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row mobile extra', 'makbet'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('makbet_options_wocommerce_row_mobile', array(
                'type'              => 'option',
                'default'           => 1,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('makbet_options_wocommerce_row_mobile', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row mobile', 'makbet'),
                'type'    => 'number',
            ));

        }

    }
}
return new Makbet_Customize();
