(($) => {
    'use strict';

    const $body = $('body');
    let xhr = false;

    // Tooltip on hover
    const initTooltip = () => {
        $body.on('mouseenter', '.group-action .add-to-cart-wrapper:not(.tooltipstered), .group-action .woosw-btn:not(.tooltipstered), .group-action .woosq-btn:not(.tooltipstered), .group-action .woosc-btn:not(.tooltipstered)', function () {
            const $el = $(this);
            if ($.fn.tooltipster) {
                $el.tooltipster({
                    position: 'left',
                    theme: 'pavo-product-tooltipster',
                    delay: 0,
                    animation: 'grow',
                    functionBefore(instance) {
                        instance.content(instance._$origin.text());
                    }
                }).tooltipster('show');
            }
        });
    };

    // Change image on swatch click
    const handleProductImageSwap = () => {
        $body.on('click', '.product-block .product-color .item', function () {
            const $this = $(this);
            const image = $this.data('image');
            const $product = $this.closest('.product-block');
            const $img = $product.find('.product-image img');

            $img.attr({
                src: image.src,
                srcset: image.srcset,
                sizes: image.sizes
            });

            if (!$this.hasClass('active-swatch')) {
                $this.siblings('.active-swatch').removeClass('active-swatch');
                $this.addClass('active-swatch');
            }
        });
    };

    // Update wishlist count via Ajax
    const initWishlistCount = () => {
        const updateCount = (url, action, countSelector, countUpdateCallback) => {
            $.ajax({
                url,
                data: { action },
                dataType: 'json',
                success: (data) => {
                    countSelector.html(data.count || countSelector.html());
                    $('.wishlist-count-text').html(data.text);
                    if (countUpdateCallback) countUpdateCallback(data);
                }
            });
        };

        const countEls = $('.header-wishlist .count, .footer-wishlist .count, .header-wishlist .wishlist-count-item');

        $(document).on('added_to_wishlist removed_from_wishlist', () => {
            updateCount(yith_wcwl_l10n.ajax_url, 'yith_wcwl_update_wishlist_count', countEls);
        });

        $body.on('woosw_change_count', (e, count) => {
            countEls.html(count);
            updateCount(woosw_vars.ajax_url, 'woosw_ajax_update_count', countEls);
        });
    };

    // Adjust <select> width to fit selected option text
    const enhanceOrderbySelect = () => {
        $('.woocommerce-ordering select').on('change', function () {
            const text = $(this).find('option:selected').text();
            const $aux = $('<select/>').append($('<option/>').text(text));
            $(this).after($aux);
            $(this).width($aux.width());
            $aux.remove();
        }).trigger('change');
    };

    // Ajax load product grid
    const sendRequest = (url, append = false) => {
        if (xhr) xhr.abort();

        xhr = $.ajax({
            type: 'GET',
            url,
            beforeSend: () => {
                if (!append) {
                    $('ul.makbet-products').addClass('preloader');
                }
            },
            success: (data) => {
                const $html = $(data);
                const $productList = $('#main ul.makbet-products');

                if (append) {
                    $productList.append($html.find('#main ul.makbet-products > li'));
                } else {
                    $productList.replaceWith($html.find('#main .makbet-products-grid'));
                }

                $('#main .woocommerce-pagination-wrap').replaceWith($html.find('#main .woocommerce-pagination-wrap'));
                window.history.pushState(null, null, url);
                xhr = false;
                $(document).trigger('makbet-products-loaded');
            }
        });
    };

    // Infinite scroll pagination
    const initPaginationScroll = () => {
        if (!$.fn.waypoint) return;

        const $btn = $('.products-load-more-btn.load-on-scroll');
        if ($btn.length) {
            $btn.waypoint(() => {
                if (!$btn.hasClass('loading')) {
                    $btn.trigger('click');
                }
            }, {
                offset: '100%',
                triggerOnce: false
            });
        }
    };

    // Sidebar filter toggle
    const initSidebarDropdown = () => {
        $body.on('click', '.widget.makbet-widget-woocommerce .widgettitle', function (e) {
            e.preventDefault();

            const $title = $(this);
            const $parent = $title.closest('.makbet-menu-filter');

            if ($parent.length) {
                $parent.find('.toggled-on').not($title).removeClass('toggled-on')
                    .siblings('.widget-content').slideUp()
                    .closest('.widget').removeClass('active');
            }

            $title.toggleClass('toggled-on')
                .siblings('.widget-content').slideToggle()
                .closest('.widget').toggleClass('active');
        });
    };

    // Product categories widget (currently minimal)
    const initWidgetCategories = () => {
        const $widget = $('.widget_product_categories');
        if ($widget.length) {
            // Reserved for future functionality or expand/collapse logic
        }
    };

    // Events
    const bindEvents = () => {
        // Per page dropdown
        $body.on('change', '.makbet-products-per-page #per_page', function (e) {
            e.preventDefault();
            sendRequest(this.value);
        });

        // Load more
        $body.on('click', '.products-load-more-btn', function (e) {
            e.preventDefault();
            $(this).addClass('loading');
            sendRequest($(this).attr('href'), true);
        });

        // Grid/List toggle
        $body.on('click', '.gridlist-toggle a', function (e) {
            e.preventDefault();
            $('.gridlist-toggle a').removeClass('active');
            $(this).addClass('active');
            sendRequest($(this).attr('href'));
        });
    };

    // Initialize on document ready
    $(document).ready(() => {
        initWidgetCategories();
    }).on('makbet-products-loaded', () => {
        $('.products-load-more-btn').removeClass('loading');
        initPaginationScroll();
    });

    // Init all
    initSidebarDropdown();
    initPaginationScroll();
    enhanceOrderbySelect();
    handleProductImageSwap();
    initTooltip();
    initWishlistCount();
    bindEvents();

})(jQuery);