(function ($) {
    "use strict";

    function splitTextIntoWordsAndDivLetters(element) {
        let text = $(element).text().trim();
        if (!text) return;

        let words = text.split(' ');
        let html = words.map((word, wordIndex) => {
            let lettersHTML = word.split('').map((letter) => {
                return `<div class="letter-class" style="
                    position: relative;
                    display: inline-block;
                    opacity: 0;
                    visibility: hidden;
                    transform: translate(20px, 0);
                    transition: transform 0.3s ease, opacity 0.3s ease;
                    will-change: transform, opacity;
                ">${letter}</div>`;
            }).join('');

            return `
                <div class="word-wrapper" style="position: relative;display: inline-block;" data-word-index="${wordIndex}">
                    ${lettersHTML}
                </div>
            `;
        }).join(' ');

        return html;
    }

    function animateLettersSequentially(wordWrappers, wordIndex = 0, letterIndex = 0) {
        if (wordIndex >= wordWrappers.length) return;

        const currentWord = wordWrappers[wordIndex];
        const letters = currentWord.querySelectorAll('.letter-class');

        if (letterIndex < letters.length) {
            const letter = letters[letterIndex];
            letter.style.opacity = '1';
            letter.style.visibility = 'visible';
            letter.style.transform = 'translate(0, 0)';

            setTimeout(() => {
                animateLettersSequentially(wordWrappers, wordIndex, letterIndex + 1);
            }, 50);
        } else {
            setTimeout(() => {
                animateLettersSequentially(wordWrappers, wordIndex + 1, 0);
            }, 150);
        }
    }

    function isInViewport(element) {
        let rect = element.getBoundingClientRect();
        return (
            rect.top >= 0 &&
            rect.left >= 0 &&
            rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
            rect.right <= (window.innerWidth || document.documentElement.clientWidth)
        );
    }

    function processHeadings() {
        $('.heading-effect-yes').each(function () {
            let heading = $(this).find('h1, h2, h3, h4, h5, h6').first();
            if (heading.length && !heading.hasClass('split-done')) {
                let newHTML = splitTextIntoWordsAndDivLetters(heading);
                heading.html(newHTML).addClass('split-done');
            }
        });

        $('.heading-effect-yes').each(function () {
            let heading = this.querySelector('h1, h2, h3, h4, h5, h6');
            if (!heading) return;

            if (isInViewport(heading) && !heading.classList.contains('words-visible')) {
                heading.classList.add('words-visible');
                let wordWrappers = heading.querySelectorAll('.word-wrapper');
                animateLettersSequentially(wordWrappers);
            }
        });
    }

    $(document).ready(function () {
        processHeadings();

        $(window).on('scroll resize', processHeadings);

        if (typeof elementorFrontend !== 'undefined') {
            elementorFrontend.hooks.addAction('frontend/element_ready/widget', function (scope) {
                if ($(scope).hasClass('heading-effect-yes') || $(scope).find('.heading-effect-yes').length) {
                    processHeadings();
                }
            });
        }
    });

})(jQuery);
