(function ($) {
    'use strict';

    $(document).ready(function () {
        // Toggle mobile navigation open/close
        $('.menu-mobile-nav-button').on('click', function (e) {
            e.preventDefault();
            $('html').toggleClass('mobile-nav-active');
        });

        // Close mobile navigation when clicking overlay or close button
        $('.makbet-overlay, .mobile-nav-close').on('click', function (e) {
            e.preventDefault();
            $('html').toggleClass('mobile-nav-active');
        });

        // Toggle info canvas open/close
        $('.makbet-info-button').on('click', function (e) {
            e.preventDefault();
            $('html').toggleClass('info-canvas-active');
        });

        // Close info canvas when clicking overlay or close button
        $('.makbet-info-overlay, .makbet-canvas-info-close').on('click', function (e) {
            e.preventDefault();
            $('html').removeClass('info-canvas-active');
        });

        // Mobile menu dropdown toggles
        var $menuMobile = $('.handheld-navigation');

        if ($menuMobile.length) {
            $menuMobile.find('.menu-item-has-children > a, .page_item_has_children > a').each(function () {
                var $dropdown = $(this);
                $dropdown.addClass('menu-title');
                $dropdown.on('click', function (e) {
                    e.preventDefault();
                    $dropdown.toggleClass('toggled-on');
                    $dropdown.siblings('ul').stop(true, true).slideToggle(400);
                });
            });
        }

        // Mobile nav tabs switching
        $('.mobile-nav-tabs li').on('click', function () {
            var $this = $(this);
            if ($this.hasClass('active')) return;

            var menuName = $this.data('menu');
            $this.siblings('.active').removeClass('active');
            $this.addClass('active');

            $('.mobile-menu-tab').removeClass('active');
            $('.mobile-' + menuName + '-menu').addClass('active');
        });
    });
})(jQuery);
