(function ($) {
    "use strict";

    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-transform.default', function ($element) {
            const transformItems = $element.find('.elementor-transform-item');
            const transformWrap = $element.find('.elementor-transform-wrapper');

            if (transformItems.length === 0 || transformWrap.length === 0) return;

            const firstItem = transformItems.first();
            const lastItem = transformItems.last();

            function computeTransform(progress, direction = 1) {
                const translateX = direction * (1 - progress) * 50;
                const translateY = (1 - progress) * 2;
                const rotateZ = direction * (1 - progress) * -10.71;

                return {
                    transform: `translate3d(${translateX}%, ${translateY}%, 0px) rotateZ(${rotateZ}deg)`,
                };
            }

            function resetTransform() {
                return {
                    transform: `translate3d(0%, 0%, 0px) rotateZ(0deg)`,
                };
            }

            function onScroll() {
                if (window.innerWidth <= 1024) {
                    transformItems.css(resetTransform());
                    return;
                }

                const rect = transformWrap[0].getBoundingClientRect();
                const viewportHeight = window.innerHeight;

                const widgetTop = rect.top;
                const widgetCenter = widgetTop + rect.height / 2;
                const viewportCenter = viewportHeight / 2;

                const distanceToCenter = Math.abs(widgetCenter - viewportCenter);
                const activeRange = viewportHeight / 2 - 50;
                const progress = 1 - Math.min(distanceToCenter / activeRange, 1);

                if (widgetCenter < viewportCenter) {
                    firstItem.css(resetTransform());
                    lastItem.css(resetTransform());
                } else {
                    firstItem.css(computeTransform(progress, 1));
                    lastItem.css(computeTransform(progress, -1));
                }
            }

            $(window).on('scroll resize', onScroll);
            onScroll();
        });
    });
})(jQuery);
