(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-service.default', ($element) => {
            let addHandler = $('.makbet-swiper-wrapper', $element);
            if (addHandler.length > 0) {
                elementorFrontend.elementsHandler.addHandler(makbetSwiperBase, {
                    $element,
                });
            }

            $element.find('svg.svg-gradient-text').each(function () {
                const svg = this;
                const text = svg.querySelector('text');
                if (!text) return;

                const bbox = text.getBBox();

                svg.setAttribute('width', bbox.width);
                svg.setAttribute('height', bbox.height);
                svg.setAttribute('viewBox', `0 0 ${bbox.width} ${bbox.height}`);
                text.setAttribute('y', -bbox.y);
            });

            // style 3

            if ($('.makbet-service-style-3', $element).length) {
                const $items = $('.makbet-service-style-3');
                const $defaultItem = $items.eq(1);

                $items.removeClass('active');
                $defaultItem.addClass('active');

                $(document).on('mouseenter', '.makbet-service-style-3', function () {
                    const $this = $(this);
                    $items.removeClass('active');
                    $this.addClass('active');
                });

                $(document).on('mouseleave', '.makbet-service-style-3', function () {
                    $items.removeClass('active');
                    $defaultItem.addClass('active');
                });

                $(document).on('click', '.makbet-service-style-3 .entry-main a, .makbet-service-style-3 .service-icon', function (e) {
                    e.preventDefault();
                    const link = $(this).closest('.makbet-service-style-3').data('link');
                    if (link) {
                        window.location.href = link;
                    }
                });
            }


            // style 4

            if ($('.service-style-4', $element).length) {
                const section = $('.service-style-4', $element || document);
                const serviceListWrapper = section.find('.service-list-wrapper');
                const serviceList = section.find('.service-list');
                const serviceItems = section.find('.service-title-item');
                const serviceImageContainer = section.find('.service-image');
                const imageElements = [];
                let isScrolling = false;

                if (!section.length || !serviceListWrapper.length || !serviceList.length || !serviceItems.length || !serviceImageContainer.length) return;

                serviceImageContainer.css('position', 'sticky');

                serviceItems.each(function () {
                    const src = $(this).data('image');
                    const $img = $('<img>').attr('src', src);
                    serviceImageContainer.append($img);
                    imageElements.push($img);
                });

                function updateActiveItem() {
                    // if (window.innerWidth < 768) return;

                    let activeIndex = 0;
                    let minDistance = Infinity;
                    const viewportTop = window.scrollY + window.innerHeight * 0.25;

                    serviceItems.each(function (i) {
                        const rect = this.getBoundingClientRect();
                        const itemTop = rect.top + window.scrollY;
                        const distance = Math.abs(itemTop - (viewportTop - 100)); // shift active threshold earlier by 100px
                        if (distance < minDistance) {
                            minDistance = distance;
                            activeIndex = i;
                        }
                    });

                    serviceItems.removeClass('active complete');
                    serviceItems.each(function (i) {
                        if (i < activeIndex) {
                            $(this).addClass('complete');
                        } else if (i === activeIndex) {
                            $(this).addClass('active');
                        }
                    });

                    updateImageOpacity(activeIndex);
                    updateLineFillProgress(activeIndex);
                }

                function updateImageOpacity(activeIndex) {
                    let blend = 0;
                    const currentItem = serviceItems[activeIndex];
                    const nextItem = serviceItems[activeIndex + 1];

                    if (nextItem) {
                        const currentTop = currentItem.getBoundingClientRect().top + window.scrollY;
                        const nextTop = nextItem.getBoundingClientRect().top + window.scrollY;
                        const center = window.scrollY + window.innerHeight * 0.25;
                        blend = Math.min(1, Math.max(0, (center - currentTop) / (nextTop - currentTop)));
                    }

                    imageElements.forEach(($img, i) => {
                        if (i === activeIndex) {
                            $img.css('opacity', 1 - blend);
                        } else if (i === activeIndex + 1) {
                            $img.css('opacity', blend);
                        } else {
                            $img.css('opacity', 0);
                        }
                    });
                }

                function updateLineFillProgress(activeIndex) {
                    const center = window.scrollY + window.innerHeight * 0.25;

                    serviceItems.each(function (i) {
                        const $item = $(this);
                        const itemTop = $item.offset().top;
                        const itemHeight = $item.outerHeight();

                        let progress = 0;

                        // make line fill begin sooner (starts earlier by 50px)
                        const earlyCenter = center + 50;

                        if (earlyCenter >= itemTop + itemHeight) {
                            progress = 1;
                        } else if (earlyCenter >= itemTop) {
                            progress = (earlyCenter - itemTop) / itemHeight;
                        }

                        progress = Math.max(0, Math.min(1, progress));

                        $item.find('.timeline-line-fill').css({
                            height: `${progress * 100}%`,
                            transform: 'none'
                        });

                        const maxHeight = 40;
                        $item.find('.button-service').css({
                            height: `${progress * maxHeight}px`
                        });
                    });
                }

                function updateStickyImage() {
                    serviceImageContainer.css('transform', `translateY(0px)`);
                }

                function adjustPaddingForLastImage() {
                    if (window.innerWidth < 768) {
                        serviceList.css('padding-bottom', '');
                        return;
                    }

                    const lastItem = serviceItems.last();
                    const lastItemHeight = lastItem.outerHeight();
                    const imageHeight = serviceImageContainer.outerHeight();
                    // const paddingBottom = Math.max(0, imageHeight - lastItemHeight);
                    const paddingBottom = 0;
                    serviceList.css('padding-bottom', `${paddingBottom}px`);
                }

                function throttleScroll() {
                    if (!isScrolling) {
                        isScrolling = true;
                        requestAnimationFrame(() => {
                            updateActiveItem();
                            updateStickyImage();
                            isScrolling = false;
                        });
                    }
                }

                $(window).on('scroll', throttleScroll);
                $(window).on('resize', () => {
                    updateActiveItem();
                    updateStickyImage();
                    adjustPaddingForLastImage();
                });

                updateActiveItem();
                updateStickyImage();
                adjustPaddingForLastImage();
            }

        });
    });
})(jQuery);
