(function ($) {
    "use strict";

    const MakbetProgressHandler = function ($scope) {
        // Animate LINE
        $scope.find('.makbet-progress-line-bar').each(function () {
            const $bar = $(this);
            const max = $bar.data('max') || 0;
            const $container = $bar.closest('.makbet-progress-line-container');
            const $percentText = $container.find('.makbet-progress-percentage');

            $bar.css({ width: 0 });
            setTimeout(() => {
                $bar.css({ width: max + '%' });
                $percentText.css({ left: max + '%' });
            }, 100);

            // Animate number count up
            if ($percentText.length) {
                let current = 0;
                const step = max / 30;
                const interval = setInterval(() => {
                    current += step;
                    if (current >= max) {
                        current = max;
                        clearInterval(interval);
                    }
                    $percentText.text(Math.round(current) + '%');
                }, 30);
            }
        });

        // Animate CIRCLE
        $scope.find('.makbet-progress-circle-wrapper').each(function () {
            const $wrapper = $(this);
            const $circle = $wrapper.find('circle.makbet-progress-fg');
            const percent = $wrapper.data('max') || 0;

            const radius = $circle.attr('r');
            const circumference = 2 * Math.PI * radius;
            const offset = circumference - (percent / 100) * circumference;

            $circle.css({
                strokeDasharray: circumference,
                strokeDashoffset: circumference,
                transition: 'stroke-dashoffset 1s ease'
            });

            setTimeout(() => {
                $circle.css('stroke-dashoffset', offset);
            }, 100);

            const $text = $wrapper.find('.makbet-progress-percentage');
            if ($text.length) {
                let current = 0;
                const step = percent / 30;
                const interval = setInterval(() => {
                    current += step;
                    if (current >= percent) {
                        current = percent;
                        clearInterval(interval);
                    }
                    $text.text(Math.round(current) + '%');
                }, 30);
            }
        });
    };

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/makbet-progress-bar.default', MakbetProgressHandler);
    });
})(jQuery);
