(function ($) {
	"use strict";

	$(function () {
		const $imageGalleryIds = $('#product_360_image_gallery');
		const $productImages = $('#product_360_images_container ul.product_360_images');
		let productGalleryFrame;

		// Open media frame
		$('.add_product_360_images').on('click', 'a', function (event) {
			event.preventDefault();

			const $el = $(this);

			// Reopen if already exists
			if (productGalleryFrame) {
				productGalleryFrame.open();
				return;
			}

			// Create media frame
			productGalleryFrame = wp.media.frames.productGallery = wp.media({
				title: $el.data('choose'),
				button: { text: $el.data('update') },
				multiple: true
			});

			// On selection
			productGalleryFrame.on('select', function () {
				const selection = productGalleryFrame.state().get('selection');
				let attachmentIds = $imageGalleryIds.val() || '';

				selection.each(function (attachment) {
					const data = attachment.toJSON();
					const imageUrl = data.sizes?.thumbnail?.url || data.url;

					attachmentIds += attachmentIds ? `,${data.id}` : data.id;

					$productImages.append(`
                        <li class="image" data-attachment_id="${data.id}">
                            <img src="${imageUrl}" />
                            <ul class="actions">
                                <li><a href="#" class="delete" title="${$el.data('delete')}">${$el.data('text')}</a></li>
                            </ul>
                        </li>
                    `);
				});

				$imageGalleryIds.val(attachmentIds);
			});

			productGalleryFrame.open();
		});

		// Sort images
		if ($.fn.sortable) {
			$productImages.sortable({
				items: 'li.image',
				cursor: 'move',
				placeholder: 'wc-metabox-sortable-placeholder',
				opacity: 0.65,
				start: (e, ui) => ui.item.css('background-color', '#f6f6f6'),
				stop: (e, ui) => ui.item.removeAttr('style'),
				update: updateAttachmentIds
			});
		}

		// Remove image
		$('#product_360_images_container').on('click', 'a.delete', function (e) {
			e.preventDefault();
			$(this).closest('li.image').remove();
			updateAttachmentIds();

			// Clear tooltips
			$('#tiptip_holder, #tiptip_arrow').removeAttr('style');
		});

		function updateAttachmentIds() {
			const ids = $productImages.find('li.image')
				.map(function () {
					return $(this).data('attachment_id');
				})
				.get()
				.join(',');
			$imageGalleryIds.val(ids);
		}
	});

})(jQuery);
